﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text.RegularExpressions;
using System.Web.Security.AntiXss;
using VIRP_WEB.BaseCode;
using VIRP_WEB.Controls.Custom.EFR;
using VIRP.EFR.DAL;
using VIRP.EFR.BLL;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB.Custom.EFR
{
    public partial class DoDFragmentLab : EfrBasePage
    {
        //private DoDFragmentManager manager = new DoDFragmentManager();
        private DoDFragmentDB manager = new DoDFragmentDB();
        protected readonly string DoDFragmentPage = "~/Custom/EFR/DoDFragment/DoDFragment.aspx?patientId=";
        private string pFullName = "";

        protected override void Page_Load(object sender, EventArgs e)
        {
            LoadBaseControls();

            if (!IsPostBack)
            {
                ((Label)Master.FindControl("EfrPageTitle")).Text = "DoD Fragment Lab";

                HiddenFieldPatientID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"], false);
                HiddenFieldDoDFragmentLabID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["dodFragmentLabId"], false);
            }

            DisplayPatientInfo();

            string pageMode = "Add Lab Data";

            if (!string.IsNullOrEmpty(HiddenFieldDoDFragmentLabID.Value)
                && HiddenFieldDoDFragmentLabID.Value != "0")
                pageMode = "Edit Lab Data";

            ReplacePageTitle("Patients > Patient Lookup > Workflows > DoD Fragment Data > " + pageMode + " > " + pFullName);
        }

        protected void Page_PreRender(object sender, EventArgs e)
        {
            LoadControlsFromObject();
        }

        private void DisplayPatientInfo()
        {
            if (!string.IsNullOrEmpty(BaseCode.Helpers.AntiXssEval(Request.QueryString["patientId"])))
            {
                int patientId = Convert.ToInt32(BaseCode.Helpers.AntiXssEval(Request.QueryString["patientId"]));

                VIRP.CRS.BO.PATIENT p = VIRP.CRS.BLL.PATIENTManager.GetItem(CurrentUser, CurrentRegistryId, patientId);
                VIRP.CRS.BO.PATIENT_REG pr = VIRP.CRS.BLL.PATIENT_REGManager.GetItem(CurrentUser, CurrentRegistryId, patientId);

                if (p != null)
                {
                    BaseControlLabelPatientFullName.Text = pFullName = p.FULL_NAME;
                    BaseControlLabelPatientSSN.Text = pr.Snum;
                }
            }
        }

        public enum EfrBaseControlType
        {
            None = 0,
            Label = 1,
            TextBox = 2,
            RadioButtonList = 3,
            DropDownList = 4
        }

        private void LoadBaseControls()
        {
            CommonManager commonManager = new CommonManager();
            List<STD_GUI_CONTROL> controls = commonManager.GetStdGuiControlsByCategory("DOD_FRAGMENT_LAB_DATA_ENTRY", UserSession.CurrentRegistryId);

            foreach (STD_GUI_CONTROL dbItem in controls)
            {
                Control userControl = null;

                if (dbItem.BASE_CONTROL_TYPE == (int)EfrBaseControlType.Label)
                {
                    userControl = PanelPatient.FindControl(dbItem.USER_CONTROL_ID);
                    if (userControl != null)
                    {
                        BaseControlLabel baseControl = (BaseControlLabel)userControl;
                        baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL);
                    }
                }
                else
                {
                    userControl = PanelFragmentLabData.FindControl(dbItem.USER_CONTROL_ID);
                    if (userControl != null)
                    {
                        BaseControlTextBox baseControl = (BaseControlTextBox)userControl;
                        baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH);
                    }
                }
            }
        }

        protected void ButtonBack_Click(object sender, EventArgs e)
        {
            ResponseRedirect(DoDFragmentPage, GetValidStringValue(HiddenFieldPatientID.Value));
        }

        protected void ButtonSave_Click(object sender, EventArgs e)
        {
            DOD_FRAGMENT_LAB lab = LoadObjectFromControls();
            lab.CREATED = lab.UPDATED = DateTime.UtcNow;
            lab.CREATEDBY = lab.UPDATEDBY = HttpContext.Current.User.Identity.Name;

            VIRP.EFR.BO.DOD_FRAGMENT_LAB labDb = new VIRP.EFR.BO.DOD_FRAGMENT_LAB();
            labDb.CREATED = lab.CREATED;
            labDb.CREATEDBY = lab.CREATEDBY;
            labDb.DOD_FRAGMENT_LAB_ID = lab.DOD_FRAGMENT_LAB_ID;
            labDb.LAB_ACCESSION_NUMBER = lab.LAB_ACCESSION_NUMBER;
            labDb.LAB_CODE = lab.LAB_CODE;
            labDb.LAB_ID = lab.LAB_ID;
            labDb.LAB_NAME = lab.LAB_NAME;
            labDb.LAB_REPORT_DATE = lab.LAB_REPORT_DATE;
            labDb.PATIENT_ID = lab.PATIENT_ID;
            labDb.PRODUCING_EVENT_DATE = lab.PRODUCING_EVENT_DATE;
            labDb.UPDATED = lab.UPDATED;
            labDb.UPDATEDBY = lab.UPDATEDBY;

            DOD_FRAGMENT_LABManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, labDb);
            //lab = manager.Update(lab);
            HiddenFieldDoDFragmentLabID.Value = lab.DOD_FRAGMENT_LAB_ID.ToString();

            ResponseRedirect(DoDFragmentPage, GetValidStringValue(HiddenFieldPatientID.Value));
        }

        private string GetValidStringValue(string pCurrentQueue)
        {
            string currentQueue = string.Empty;
            if (pCurrentQueue != null)
            {
                if (Regex.IsMatch(pCurrentQueue, "^[a-zA-Z0-9]*$"))
                {
                    currentQueue = pCurrentQueue;
                }
            }
            return currentQueue;
        }

        private DOD_FRAGMENT_LAB LoadObjectFromControls()
        {
            DOD_FRAGMENT_LAB lab = new DOD_FRAGMENT_LAB();

            if (!string.IsNullOrEmpty(HiddenFieldDoDFragmentLabID.Value))
            {
                // lab = (DOD_FRAGMENT_LAB)Session["DoDLab"];
                lab = VIRP.EFR.BO.SessionItemReference<DOD_FRAGMENT_LAB>.Get(Session["DoDLab"]);
                //lab.SetAsChangeTrackingRoot(false);
                //lab.SetAsUpdateOnSubmit();
            }
            else
            {
                //lab.SetAsChangeTrackingRoot();
                //lab.SetAsInsertOnSubmit();
                lab.PATIENT_ID = Helpers.GetIntFromString(HiddenFieldPatientID.Value);
            }

            lab.LAB_NAME = BaseControlTextBoxLabName.Text;
            lab.LAB_REPORT_DATE = BaseControlTextBoxLabReportDate.Text;
            lab.LAB_CODE = BaseControlTextBoxLabCode.Text;
            lab.LAB_ID = BaseControlTextBoxLabID.Text;
            lab.LAB_ACCESSION_NUMBER = BaseControlTextBoxLabAccessionNumber.Text;
            lab.PRODUCING_EVENT_DATE = BaseControlTextBoxLabProducingEventDate.Text;

            return lab;
        }

        private void LoadControlsFromObject()
        {
            if (!string.IsNullOrEmpty(HiddenFieldDoDFragmentLabID.Value)
                && HiddenFieldDoDFragmentLabID.Value != "0")
            {
                DOD_FRAGMENT_LAB lab = manager.GetDoDFragmentLabById(Helpers.GetIntFromString(HiddenFieldDoDFragmentLabID.Value));
                //DOD_FRAGMENT_LAB lab = DOD_FRAGMENT_LABManager.GetItem(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, Helpers.GetIntFromString(HiddenFieldDoDFragmentLabID.Value));
                BaseControlTextBoxLabName.Text = lab.LAB_NAME;
                BaseControlTextBoxLabReportDate.Text = lab.LAB_REPORT_DATE;
                BaseControlTextBoxLabCode.Text = lab.LAB_CODE;
                BaseControlTextBoxLabID.Text = lab.LAB_ID;
                BaseControlTextBoxLabAccessionNumber.Text = lab.LAB_ACCESSION_NUMBER;
                BaseControlTextBoxLabProducingEventDate.Text = lab.PRODUCING_EVENT_DATE;

                Session["DoDLab"] = VIRP.EFR.BO.SessionItemFactory.Create(lab);
                //Session["DoDLab"] = lab;
            }
            else
            {
                Session["DoDLab"] = null;
            }
        }

        private void ResponseRedirect(string destination, string queryString)
        {
            try
            {
                string queryStringValue = string.Empty;
                if (queryString != null)
                {
                    queryStringValue = AntiXssEncoder.UrlEncode(queryString);
                }

                string destinationUrl = string.Concat(destination, queryStringValue);
                string currentHost = Request.Url.Host;
                if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
                {
                    Server.Transfer(destinationUrl);
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError("Failure in to redirect to Export page: - DOD Fragment page.: " + ex.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            }
        }
    }
}
